var fso,wsh,WorkSpace,project,projectFolder,configIniFile;
try {
    // fso = new ActiveXObject('Scripting.FileSystemObject');
    // wsh = new ActiveXObject("WScript.Shell");
    // WorkSpace = GetWorkspace();
    // project = WorkSpace && WorkSpace.DM_FocusedProject();
    // // projectFolder = project ? project.DM_GetOutputPath().replace(/\\[^\\]+\\*$/, '') : "";
    // projectFolder = project ? (project.DM_ProjectFullPath + '').replace(/\\[^\\]+\\*$/, '') : "";
    // configIniFile = projectFolder ? projectFolder + "\\config.ini" : "";
} catch (error) {
    showmessage("init error: " + error.Message);
}
//showmessage("Desktop: " + wsh.SpecialFolders("Desktop"));
//showmessage("MyDocuments: " + wsh.SpecialFolders("MyDocuments"));
//showmessage("getTime: " + (new Date()).getTime());
// var path = projectFolder || wsh.SpecialFolders("MyDocuments") + '\\convertLibToAscii-' + (new Date()).getTime();

var defaultFormCaption = '';
var ver = '1.9.1';
var source = '';
var des = '';
var logPath = '';
var saveCount = 1000; //1000
var maxCapacity = 1000; //1000
var nowCount = 0;
var nowCapacity = 0;
var ForReading = 1, ForWriting = 2, ForAppending = 8;
var convertSuccess = [];
var convertFail = [];
var configObj = {convertLib:{}};
var footprintsArray = [];
var xDis = 100, yDis = 100, cols = 20;
var currRowIndex = 0, currColIndex = 0;
var libsPath;
var availableLibraryPaths;

String.prototype.trim = String.prototype.trim || function () {
    return this.replace(/^\s+|\s+$/g, '');
};


function readIniToJson(filePath) {
    if (!fso.FileExists(filePath)) {
        return null;
    }
    var iniFileObj = fso.OpenTextFile(filePath, ForReading, false);
    var iniText = iniFileObj.ReadAll();
    iniFileObj.Close();
    var lines = iniText.split(/\r?\n/);
    var result = {};
    var currentSection = null;
  
    for (var i = 0; i < lines.length; i++) {
      var line = lines[i].trim();
      if (!line || line[0]==";" || line[0]=="#") continue;

      var sectionMatch = line.match(/^\[(.+?)\]$/);
      if (sectionMatch) {
        currentSection = sectionMatch[1];
        result[currentSection] = result[currentSection] || {};
        continue;
      }
  
      var kv = line.split("=");
      if (kv.length >= 2) {
        var key = kv.shift().trim();
        var value = kv.join("=").trim();
        if (currentSection) {
          result[currentSection][key] = value;
        } else {
          result[key] = value;
        }
      }
    }
    return result;
}
function writeJsonToIni(json, filePath) {
    var lines = [];
    for (var sectionKey in json) {
        if (Object.prototype.hasOwnProperty.call(json, sectionKey)) {
            var sectionValue = json[sectionKey];
            if (typeof sectionValue === "object" && sectionValue !== null) {
              // section
              lines.push('[' + sectionKey + ']');
              for (var itemKey in sectionValue) {
                lines.push(itemKey + '=' + sectionValue[itemKey]);
              }
              lines.push("");
            } else {
              lines.push(key + '=' + value);
            }
        }
    }
    var iniFileObj = fso.OpenTextFile(filePath, ForWriting, true);
    iniFileObj.Write(lines.join("\r\n"));
    iniFileObj.Close();
}
function loadIniConfig() {
    if (configIniFile && fso && fso.FileExists(configIniFile)) {
        try {
            configObj = readIniToJson(configIniFile) || {};
            var libConfig = configObj.convertLib;
            if (libConfig) {
                if (libConfig.source) {
                    source = libConfig.source;
                }
                if (libConfig.des) {
                    des = libConfig.des;
                }
                xDis = libConfig.xDis || xDis;
                yDis = libConfig.yDis || yDis;
                cols = libConfig.cols || cols;
                saveCount = libConfig.saveCount || saveCount;
                maxCapacity = libConfig.maxCapacity || maxCapacity;
            } else {
                configObj.convertLib = {};
            }
        } catch (error) {
            showmessage("load ini error: " + error.Message);
        }
    }
}
function createDir(path) {
    if (!fso.FolderExists(path)) {
        fso.CreateFolder(path);
    }
}
function checkDirPath(path) {
    var rex = new RegExp(/\\([^\\]+)/g);
    var dir = [];
    var res;
    var start;
    while ((res = rex.exec(path)) != null) {
        if (!start) start = res.index;
        dir.push(res[1]);
    }
    var _path = path.slice(0, start);
    for (var i = 0; i < dir.length; i++) {
        _path += '\\' + dir[i];
        createDir(_path);
    }
}
function console(key, value) {
    var logFile = fso.OpenTextFile(logPath, ForAppending, true);
    if(key!=""){
        logFile.write(key);
        logFile.write(':');
    }
    logFile.write(value);
    logFile.write('\r\n');
    logFile.Close();
}

function getAllLib(source) {
    var schLibPaths = [];
    var pcbLibPaths = [];
    var intLibPaths = [];
    if (fso.FolderExists(source)) {
        saveFolderFile(source);
    } else if (fso.FileExists(source)) {
        saveFile(source);
    } else {
        console('error', 'The source file path does not exist');
    }
    function saveFile(path) {
        var type = path.toString().toLowerCase();
        if (type.match(/.pcblib$/)) return pcbLibPaths.push(path);
        if (type.match(/.schlib$/)) return schLibPaths.push(path);
        if (type.match(/.intlib$/)) return intLibPaths.push(path);
    }
    function saveFolderFile(libDir) {
        var folder = fso.GetFolder(libDir);
        var files = new Enumerator(folder.files);
        var folders = new Enumerator(folder.SubFolders);
        while (!files.atEnd()) {
            var fileName = files.item().name;
            if (fileName == undefined) {
                files.moveNext();
                continue;
            }
            saveFile(libDir + '\\' + fileName);
            files.moveNext();
        }
        while (!folders.atEnd()) {
            var fName = folders.item().name;
            saveFolderFile(libDir + '\\' + fName);
            folders.moveNext();
        }
    }
    return { schLibPaths: schLibPaths, pcbLibPaths: pcbLibPaths, intLibPaths: intLibPaths };
}

function getAllLib2(del) {
    var libsCount = IntegratedLibraryManager.AvailableLibraryCount();
    var schLibPaths = [];
    var pcbLibPaths = [];
    var intLibPaths = [];
    var paths = [];
    for (var i = 0; i < libsCount; i++) {
        var type = IntegratedLibraryManager.AvailableLibraryType(i);
        var path = IntegratedLibraryManager.AvailableLibraryPath(i);
        paths.push(path);
        if (type == 0) {
            intLibPaths.push(path);
        } else if (type == 1) {
            schLibPaths.push(path);
        } else if (type == 2) {
            pcbLibPaths.push(path);
        }
    }
    availableLibraryPaths = paths;
    return { schLibPaths: schLibPaths, pcbLibPaths: pcbLibPaths, intLibPaths: intLibPaths };
}
function includes(arr, path) {
    for (var i = 0; i < arr.length; i++) {
        if (arr[i] == path) return true;
    }
    return false;
}
function getDesPath(path, suffix){
    var newfile=path.replace(source,des);
    var dir=fso.GetParentFolderName(newfile);
    checkDirPath(dir);
    return  delSuffix(newfile) + suffix
}
function delSuffix(path){
    var index = path.lastIndexOf(".")
    if(index!=-1){
        return path.slice(0,index)
    }
    return path
}
function getOutDir(del) {
    checkDirPath(des);
    return des;
}
function newTempFile(del) {
    return des + '\\' + dt();
}
function dt(del) {
    return Date.parse(new Date()).toString();
}

function getFileName(path, suffix) {
    var fName = fso.getFileName(path);
    var fPath = des + '\\' + fName.slice(0, -7) + suffix;
    return fPath;
}
function a_getAllLibsByCustomLibsPath(render) {
    if (!availableLibraryPaths) getAllLib2();
    if (!libsPath) {
        libsPath = getAllLib(source);
        getOutDir();
    }
    extractFootprints_ByCustomLibsPath();
    // extractSymbols_ByCustomLibsPath();
}
function extractSymbols_ByCustomLibsPath(render) {
    for (var i = 0; i < libsPath.schLibPaths.length; i++) {
        getSchemaByPath(libsPath.schLibPaths[i]);
    }
    for (var i = 0; i < libsPath.intLibPaths.length; i++) {
        getSchemaByPath(libsPath.intLibPaths[i]);
    }
}
function getSchemaByPath(libPath) {
try{
    var schPath = getDesPath(libPath,".schdoc")
    var tempPath;
    var oldPath = schPath;
    var schDocument;
    var splitNum = 1;
    var success = false;
    function OpenDocument(del) {
        nowCount = 0;
        nowCapacity = 0;
        tempPath = newTempFile() + '.schdoc';
        schDocument = Client.OpenDocument('SCH', tempPath);
        Client.ShowDocument(schDocument);
    }
    function saveDocument(del) {
        // console('sch out', '------------------------------------');
        // console('schPath', schPath);
        // console('tempPath', tempPath);
        schDocument.DoFileSave('SCH ASCII');
        Client.CloseDocument(schDocument);
        nowCount = 0;
        nowCapacity = 0;
        if (fso.FileExists(schPath)) fso.deleteFile(schPath);
        if (fso.FileExists(tempPath)) fso.moveFile(tempPath, schPath);
        else {
            return false
            // console('split', '------------------------------------');
            // console('error', 'failed to save document');
            // console('schPath', schPath);
            // console('tempPath', tempPath);
            // console('split', '------------------------------------');
        }
        schDocument = null;
        return true;
    }
    function getSplitNextName(del) {
        splitNum++;
        var index = oldPath.lastIndexOf(".")
        if(index!=-1){
            return oldPath.slice(0,index) + '_'+ (splitNum - 1) + oldPath.slice(index)
        }
        return oldPath + '_' + (splitNum - 1);
    }
    var has = includes(availableLibraryPaths, libPath);
    if (!has) IntegratedLibraryManager.InstallLibrary(libPath);
    var libCount = IntegratedLibraryManager.GetComponentCount(libPath);
    for (var i = 0; i < libCount; i++) {
        if (!schDocument) OpenDocument();
        var compName = IntegratedLibraryManager.GetComponentName(libPath, i);
        IntegratedLibraryManager.PlaceLibraryComponent(compName, libPath, 'Orientation=0|Location.X=50000000|Location.Y=50000000');
        nowCount++;
        nowCapacity++;
        if (nowCount >= saveCount) {
            schDocument.DoFileSave('SCH ASCII');
            nowCount = 0;
        }
        if (nowCapacity > maxCapacity) {
            saveDocument();
            schPath = getSplitNextName();
        }
    }
    success = saveDocument();
    if(success){
        convertSuccess.push({libPath:libPath,isSch:true})
    }else{
        convertFail.push({libPath:libPath,isSch:true})
    }
    if (!has) IntegratedLibraryManager.UninstallLibrary(libPath);
}catch(e){
    convertFail.push({libPath:libPath,isSch:true})
}
}

function extractFootprints_ByCustomLibsPath(render) {
    
    // console('run method', 'extractFootprints');
    for (var i = 0; i < libsPath.pcbLibPaths.length; i++) {
        // console('pcblibsPath', libsPath.pcbLibPaths[i]);
        getPcbByPath(libsPath.pcbLibPaths[i], 2);
    }
    for (var i = 0; i < libsPath.intLibPaths.length; i++) {
        getPcbByPath(libsPath.intLibPaths[i], 0);
    }
    
}
function getPcbByPath(libPath, type) {
try{
    if (type == 2) {
        generatePcbDoc1(libPath)
        // if (PCBServer) {
        //     try{
        //         PCBServer.LoadPCBLibraryFromFile(libPath);
        //     }catch(e){
                
        //         return;
        //     }
        //     generatePcbDoc(libPath);
        // } else {
        //     convertFail.push({libPath:libPath,isPcb:true})
        //     console('there is no PCBServer', libPath);
        // }
        
    } else if (type == 0) {
        IntegratedLibraryManager.ExtractSources(libPath);
        var res = getAllLib(delSuffix(libPath));
        for (var i = 0; i < res.pcbLibPaths.length; i++) {
            var _libPath = res.pcbLibPaths[i];
            // console('_libPath', _libPath);
            getPcbByPath(_libPath,2);
        }
    }
}catch(e){
    convertFail.push({libPath:libPath,isPcb:true})
}
}
function generatePcbDoc(libPath){
    var success = true;
    var modelNames = [];
    try{
        var PcbLib = PCBServer.LoadPCBLibraryFromFile(libPath);
        if (PcbLib) {
            var LibIterator = PcbLib.LibraryIterator_Create;
            var LibComponent = LibIterator.FirstPCBObject;
            while (LibComponent != null) {
                modelNames.push(LibComponent.name)
                LibComponent = LibIterator.NextPCBObject;
            }
            PcbLib.LibraryIterator_Destroy(LibIterator);
            PCBServer.DestroyPCBLibrary(PcbLib);
            success = generatePcbDocByModelNames(libPath,modelNames)
        } else {
            success = false;
            Client.CloseDocument(pcbDocument);
        }
    }catch(e){
        success = false
    }
    if(success){
        convertSuccess.push({libPath:libPath,isPcb:true})
    }else{
        convertFail.push({libPath:libPath,isPcb:true})
    }
    
}
function generatePcbDoc1(libPath){
    var success = true;
    var pcbDocument;
    var modelNames = [];
    try{
        pcbDocument = Client.OpenDocument('PCBLIB', libPath);
        Client.ShowDocument(pcbDocument);
        var PcbLib = PCBServer.GetCurrentPCBLibrary
        if (PcbLib) {
            var LibIterator = PcbLib.LibraryIterator_Create;
            var LibComponent = LibIterator.FirstPCBObject;
            while (LibComponent != null) {
                modelNames.push(LibComponent.name)
                LibComponent = LibIterator.NextPCBObject;
            }
            PcbLib.LibraryIterator_Destroy(LibIterator);
            Client.CloseDocument(pcbDocument);
            success = generatePcbDocByModelNames(libPath,modelNames)
        } else {
            success = false;
            Client.CloseDocument(pcbDocument);
        }
    }catch(e){
        success = false
        if(pcbDocument){
            Client.CloseDocument(pcbDocument);
        }
    }
    if(success){
        convertSuccess.push({libPath:libPath,isPcb:true})
    }else{
        convertFail.push({libPath:libPath,isPcb:true})
    }
}
function generatePcbDocByModelNames(libPath,modelNames){
    var Board;
    var pcbDocument;
    var splitNum = 1;
    var success = true;
    footprintsArray.length = 0;
    try{
        var pcbPath = getDesPath(libPath,".pcbdoc");
        var oldPath = pcbPath;
        var has = includes(availableLibraryPaths, libPath);
        if (!has) IntegratedLibraryManager.InstallLibrary(libPath);
        // todo: delete all old files
        for(var i=0;i<modelNames.length;i++){
            var modelName = modelNames[i];
            addPcbComp(modelName);
            if (nowCount >= saveCount) {
                pcbDocument.DoFileSave('PCB Binary 5.0');
                console('save pcbdoc', pcbPath);
                nowCount = 0;
            }
            if (nowCapacity >= maxCapacity) {
                success = saveDocument() && success;
                nowCapacity = 0;
                pcbPath = getSplitNextName();
            }
        }
        if (nowCapacity < maxCapacity) {
            success = saveDocument() && success;
        }
    }catch(e){
        success = false;
        if (pcbDocument){
            pcbDocument.DoFileSave('PCB ASCII File');
            Client.CloseDocument(pcbDocument);
        }
    }
    return success;
    function addPcbComp(modelName) {
        if (!pcbDocument) OpenDocument();
        var Component = PCBServer.PCBObjectFactory(eComponentObject, eNoDimension, eCreate_Default);
        Component.SetState_Board(Board);
        Component.LoadFromLibrary('FileName=' + libPath + '|Footprint=' + modelName);
        Component.Layer = eV7_TopLayer;
        // Important!
        var x = xDis * currColIndex;
        var y = yDis * currRowIndex;
        footprintsArray.push([modelName, x, y]);
        Component.SetState_XLocation(MMsToCoord(x));
        Component.SetState_YLocation(MMsToCoord(y));
        Board.AddPCBObject(Component);
        nowCount++;
        nowCapacity++;
        if (currColIndex == cols - 1) {
            currRowIndex++;
            currColIndex = 0;
        } else {
            currColIndex++;
        }
    }
    function OpenDocument(del) {
        nowCount = 0;
        nowCapacity = 0;
        if (fso.FileExists(pcbPath)) {
            fso.DeleteFile(pcbPath);
            console('delete old file', pcbPath);
        }
        pcbDocument = Client.OpenDocument('PCB', pcbPath);
        Client.ShowDocument(pcbDocument);
        Board = PCBServer.GetCurrentPCBBoard;
    }
    function getSplitNextName(del) {
        var index = oldPath.lastIndexOf(".")
        splitNum++;
        if(index!=-1){
            return oldPath.slice(0,index) + '_'+ (splitNum-1) + oldPath.slice(index)
        }
        return oldPath+ '_'+ (splitNum-1)  
    }
    function saveDocument(del) {
        if (pcbDocument) {
            // pcbDocument.DoFileSave('PCB ASCII File');
            pcbDocument.DoFileSave('PCB Binary 5.0');
            Client.CloseDocument(pcbDocument);
            // console('pcb out', '------------------------------------');
            // console('pcbPath', pcbPath);
            // console('tempPath', tempPath);
            var csvContent = 'Name, X(mm), Y(mm)\r\n';
            for (var i = 0; i < footprintsArray.length; i++) {
                csvContent += footprintsArray[i].join(', ') + '\r\n';
            }
            var csvFilePath = pcbPath.replace(/\.pcbdoc$/i, '.csv');
            var csvFileObj = fso.OpenTextFile(csvFilePath, ForWriting, true);
            csvFileObj.Write(csvContent);
            csvFileObj.Close();
            console('write file', csvFilePath);
            nowCount = 0;
            nowCapacity = 0;
            currRowIndex = 0;
            currColIndex = 0;
            footprintsArray.length = 0;
            pcbDocument = null;
            if (!fso.FileExists(pcbPath)) {
                // convertFail.push(libPath)
                return false;
                // console('split', '------------------------------------');
                // console('error', 'failed to save document');
                // console('pcbPath', pcbPath);
                // console('tempPath', tempPath);
            }
            return true
        }
        return true
    }
}
function openDialog(sender){
     try {
            var Message = "";
            var Shell = new ActiveXObject("Shell.Application");
            var Folder = Shell.BrowseForFolder(0, Message, 0x0040, 0x11);
            if (Folder != null) {
                Folder = Folder.items();
                Folder = Folder.item();
                Folder = Folder.Path;
                return Folder;
            }
        }
        catch (e) {
            console("openfolder","false");
        }
}

function adSourceClick(Sender)
{
    var folder = openDialog();
    if(folder){
        folder = folder.trim().replace(/^"|"$/g, '').replace(/[\\\/\s]+$/g, '');
        source = folder;
        adSourceText.Text =  source;
        if (!adOutputText.Text) {
            adOutputText.Text =  source + "-output";
        }
        des = adOutputText.Text;
        configObj.convertLib.source = source;
        configObj.convertLib.des = des;
    }
}

function adOutputClick(Sender)
{
    var folder = openDialog();
    if(folder){
        folder = folder.trim().replace(/^"|"$/g, '').replace(/[\\\/\s]+$/g, '');
        des = folder;
        adOutputText.Text =  des;
        configObj.convertLib.des = des;
    }
}

function adSourceTextChange(Sender)
{
    var folder = adSourceText.Text;
    if(folder){
        folder = folder.trim().replace(/^"|"$/g, '').replace(/[\\\/\s]+$/g, '');
        source = folder;
        if (!adOutputText.Text) {
            des = source + "-output";
            adOutputText.Text =  des;
        }
        configObj.convertLib.source = source;
        configObj.convertLib.des = des;
    }
}

function adOutputTextChange(Sender)
{
    var folder = adOutputText.Text;
    if(folder){
        folder = folder.trim().replace(/^"|"$/g, '').replace(/[\\\/\s]+$/g, '');
        des = folder;
        configObj.convertLib.des = des;
    }
}


function cancelButtonClick(Sender)
{
     Close;
}

function okButtonClick(Sender)
{
    source = adSourceText.Text;
    des = adOutputText.Text;
    xDis = +adXDis.Text || xDis;
    yDis = +adYDis.Text || yDis;
    cols = +adCols.Text || cols;
    saveCount = +adCapacity.Text || saveCount;
    maxCapacity = +adCapacity.Text || maxCapacity;
    currRowIndex = 0;
    currColIndex = 0;
    nowCount = 0;
    nowCapacity = 0;
    logPath = des + '\\log.txt';
    if (!source) {
        showmessage("Source folder is required.");
        return;
    }
    if (!des) {
        showmessage("Output folder is required.");
        return;
    }
    if (!fso.FolderExists(source)) {
        showmessage("Folder does not exist: " + source);
        return;
    }
    // if (!fso.FolderExists(des) && des != source + '-output') {
    //     showmessage("Folder does not exist: " + des);
    //     return;
    // }
    if (xDis < 10 || yDis < 10) {
        showmessage("X or Y offset is invalid.");
        return;
    }
    if (cols < 1) {
        showmessage("Columns is required.");
        return;
    }
    if (saveCount < 1 || maxCapacity < 1) {
        showmessage("Capacity is required.");
        return;
    }
    if (fso.FileExists(logPath)) {
        var logFile = fso.OpenTextFile(logPath, ForWriting, true);
        logFile.write('\r\n');
        logFile.Close();
    }
    if (configIniFile) {
        configObj.convertLib = configObj.convertLib || {};
        configObj.convertLib.source = source;
        configObj.convertLib.des = des;
        configObj.convertLib.xDis = xDis;
        configObj.convertLib.yDis = yDis;
        configObj.convertLib.cols = cols;
        configObj.convertLib.saveCount = saveCount;
        configObj.convertLib.maxCapacity = maxCapacity;
        writeJsonToIni(configObj, configIniFile);
    }

    a_getAllLibsByCustomLibsPath();
    console("Convert Success",convertSuccess.length)
    for(var i=0;i<convertSuccess.length;i++){
        var res = convertSuccess[i]
        var path = res.libPath
        var key = ""
        if(res.isSch){
            key = "sch"
        }else if(res.isPcb){
            key = "pcb"
        }
        console(key,path)
    }
    console("Convert Fail",convertFail.length)
    for(var i=0;i<convertFail.length;i++){
        var res = convertFail[i]
        var path = res.libPath
        var key = ""
        if(res.isSch){
            key = "sch"
        }else if(res.isPcb){
            key = "pcb"
        }
        console(key,path)
    }
    showmessage("Convert Success")
    Close;
}

function Form1Show(Sender)
{
    defaultFormCaption = defaultFormCaption || Form1.Caption;
    Form1.Caption = defaultFormCaption + ' ' + ver;
    fso = new ActiveXObject('Scripting.FileSystemObject');
    wsh = new ActiveXObject("WScript.Shell");
    WorkSpace = GetWorkspace();
    project = WorkSpace && WorkSpace.DM_FocusedProject();
    // projectFolder = project ? project.DM_GetOutputPath().replace(/\\[^\\]+\\*$/, '') : "";
    projectFolder = project ? (project.DM_ProjectFullPath + '').replace(/\\[^\\]+\\*$/, '') : "";
    configIniFile = projectFolder ? projectFolder + "\\config.ini" : "";

    loadIniConfig();
    adSourceText.Text =  source;
    adOutputText.Text =  des;
    adXDis.Text = xDis + '';
    adYDis.Text = yDis + '';
    adCols.Text = cols + '';
    adCapacity.Text =  maxCapacity + '';
}
