var ver = '1.9.1';
var defaultFormCaption = '';
var fso = new ActiveXObject("Scripting.FileSystemObject");
var WorkSpace = GetWorkspace;
var project = WorkSpace.DM_FocusedProject();
path = "C:\\";
if (project) {
  path = project.DM_GetOutputPath();
  path = fso.getParentFolderName(path);
}
var CurrentDirectory = path;
var source = CurrentDirectory; //  define your altium projects path
var output = CurrentDirectory + "\\ascii"; //  define the export altium projects ascii files path
var log = 2;
var convertSuccess = [];
var convertFail = [];
adSourceText.Caption = source;
adOutputText.Caption = output;
function console(key, value) {
  var logFile = fso.OpenTextFile(output + "\\log.txt", log, true);
  if (key != "") {
    logFile.write(key);
    logFile.write(":");
  }
  logFile.write(value);
  logFile.write("\r\n");
  logFile.Close();
  if (log == 2) {
    log = 8;
  }
}
function createDir(path) {
  if (!fso.FolderExists(path)) {
    fso.CreateFolder(path);
  }
}
function checkDirPath(path) {
  var rex = new RegExp(/\\([^\\]+)/g);
  var dir = [];
  var res;
  var start;
  while ((res = rex.exec(path)) != null) {
    if (!start) start = res.index;
    dir.push(res[1]);
  }
  var _path = path.slice(0, start);
  for (var i = 0; i < dir.length; i++) {
    _path += "\\" + dir[i];
    createDir(_path);
  }
}
function fileIsExist(filepath, sourcePath) {
  if (fso.FileExists(filepath)) {
    convertSuccess.push(sourcePath);
  } else {
    convertFail.push(sourcePath);
  }
}
function getAllfiles(source) {
  var schPaths = [];
  var pcbPaths = [];
  if (fso.FolderExists(source)) {
    saveFolderFile(source);
  } else if (fso.FileExists(source)) {
    saveFile(source);
  } else {
    console("error", "The source file path does not exist");
  }
  function saveFile(path) {
    var type = path.toString().toLowerCase();
    if (type.match(/.pcbdoc$/)) return pcbPaths.push(path);
    if (type.match(/.schdoc$/)) return schPaths.push(path);
  }
  function saveFolderFile(libDir) {
    var folder = fso.GetFolder(libDir);
    var files = new Enumerator(folder.files);
    var folders = new Enumerator(folder.SubFolders);
    while (!files.atEnd()) {
      var fileName = files.item().name;
      if (fileName == undefined) {
        files.moveNext();
        continue;
      }
      saveFile(libDir + "\\" + fileName);
      files.moveNext();
    }
    while (!folders.atEnd()) {
      var fName = folders.item().name;
      saveFolderFile(libDir + "\\" + fName);
      folders.moveNext();
    }
  }
  return { schPaths: schPaths, pcbPaths: pcbPaths };
}
function exportAltiumAscii(sender) {
  checkDirPath(output);
  var filesPath = getAllfiles(source);
  exportAscii(filesPath["schPaths"], "SCH", "SCH ASCII");
  exportAscii(filesPath["pcbPaths"], "PCB", "PCB ASCII File");
}
function exportAscii(filePath, openType, saveType) {
  for (var i = 0; i < filePath.length; i++) {
    try {
      var path = filePath[i];
      var newfile = path.replace(source, output);
      var dir = fso.GetParentFolderName(newfile);
      checkDirPath(dir);
      newfile = newfile.slice(0, -7) + newfile.slice(-7).toLowerCase();
      fso.CopyFile(path, newfile);
      var doc = Client.OpenDocument(openType, newfile);
      doc.DoFileSave(saveType);
      fileIsExist(newfile, path);
    } catch (e) {
      convertFail.push(path);
    }
  }
}
function openDialog(sender) {
  try {
    var Message = "";
    var Shell = new ActiveXObject("Shell.Application");
    var Folder = Shell.BrowseForFolder(0, Message, 0x0040, 0x11);
    if (Folder != null) {
      Folder = Folder.items();
      Folder = Folder.item();
      Folder = Folder.Path;
      return Folder;
    }
  } catch (e) {
    console("openfolder", "false");
  }
}

function adSourceClick(Sender) {
  var folder = openDialog();
  if (folder) {
    adSourceText.Caption = folder;
    adOutputText.Caption = folder + "\\" + "ascii";
  }
}

function adOutputClick(Sender) {
  var folder = openDialog();
  if (folder) {
    adOutputText.Caption = folder;
  }
}

function cancelButtonClick(Sender) {
  Close;
}
function okButtonClick(Sender) {
  source = adSourceText.Caption;
  output = adOutputText.Caption;
  exportAltiumAscii();
  console("Convert Success", convertSuccess.length);
  for (var i = 0; i < convertSuccess.length; i++) {
    var path = convertSuccess[i];
    console("", path);
  }
  console("Convert Fail", convertFail.length);
  for (var i = 0; i < convertFail.length; i++) {
    var path = convertFail[i];
    console("", path);
  }
  showmessage("Convert Success");
  Close;
}

function Form1Show(Sender)
{
  defaultFormCaption = defaultFormCaption || Form1.Caption;
  Form1.Caption = defaultFormCaption + ' ' + ver;
}
